<?php
/**
 * Plugin Name: Ninja Beaver Lite Addons for Beaver Builder
 * Plugin URI: https://www.ninjabeaveraddon.com
 * Description: A set of custom, improvement, impressive lite modules for Beaver Builder.
 * Version: 1.1
 * Author: Ninja Team 
 * Author URI: https://www.ninjabeaveraddon.com
 * Copyright: (c) 2017 Ninja Beaver Lite Addons
 * Text Domain: bb-njba
 */
if( !class_exists( "BB_NJBA_Addon" ) ) {

	$njba_cat = esc_html__( 'NJBA Module', 'bb-njba' );
	define( 'NJBA_MODULE_DIR', plugin_dir_path( __FILE__ ) );
	define( 'NJBA_MODULE_URL', plugins_url( '/', __FILE__ ) );
	define( 'NJBA_MODULE_CAT', $njba_cat );

	class BB_NJBA_Addon {

		public function __construct()
	    {
	       	add_action( 'init', array( $this, 'njba_load_modules')  );
			add_action( 'wp_enqueue_scripts', array( $this, 'njab_load_scripts') );
			add_filter('body_class',array( $this, 'njba_body_classes'));
		}
		
		/**
		 * Ninja modules
		 */
		function njba_load_modules() {
			if ( class_exists( 'FLBuilder' ) ) {

				$njba_admin_options = get_option('njba_options');

				/* admin settings*/
					require_once 'classes/class-admin-settings.php';

				/*class fields*/
			    require_once 'classes/class-module-fields.php';
			    
			    require_once 'modules/njba-testimonials/njba-testimonials.php';
			    require_once 'modules/njba-teams/njba-teams.php';	    
			    require_once 'modules/njba-slider/njba-slider.php';
			    require_once 'modules/njba-gallery/njba-gallery.php';
			    require_once 'modules/njba-heading/njba-heading.php';
			    require_once 'modules/njba-button/njba-button.php';
			    require_once 'modules/njba-infobox-two/njba-infobox-two.php';
			    require_once 'modules/njba-advance-cta/njba-advance-cta.php';
			   	require_once 'modules/njba-infobox/njba-infobox.php';
			    require_once 'modules/njba-image-hover/njba-image-hover.php';
			    require_once 'modules/njba-alert-box/njba-alert-box.php';
			    require_once 'modules/njba-infolist/njba-infolist.php';
			    require_once 'modules/njba-icon-img/njba-icon-img.php';
			   	require_once 'modules/njba-static-map/njba-static-map.php';
			    require_once 'modules/njba-highlight-box/njba-highlight-box.php';
			    require_once 'modules/njba-social-share/njba-social-share.php';
			    require_once 'modules/njba-flip-box/njba-flip-box.php';
			    require_once 'modules/njba-image-hover-two/njba-image-hover-two.php';
			    require_once 'modules/njba-img-separator/njba-img-separator.php';
			    require_once 'modules/njba-separator/njba-separator.php';
			    require_once 'modules/njba-spacer/njba-spacer.php';
			    require_once 'modules/njba-quote-box/njba-quote-box.php';
			    require_once 'modules/njba-opening-hours/njba-opening-hours.php';
			    require_once 'modules/njba-image-panels/njba-image-panels.php';
			}
		}

		/**
		 * Ninja modules Scripts
		 */
		function njab_load_scripts()
		{

				if ( class_exists( 'FLBuilderModel' ) && FLBuilderModel::is_builder_active() ) {
					wp_enqueue_style( 'njba-fields-style', NJBA_MODULE_URL . 'assets/css/njba-fields.css', array(), rand() );
					wp_enqueue_script( 'njba-fields-script', NJBA_MODULE_URL . 'assets/js/fields.js', array( 'jquery' ), rand(), true );
				}
		}

		/**
		 * Ninja modules body class
		 */

		function njba_body_classes($classes) {

		   	 $classes[] = 'bb-njba';
			 return $classes;
		}

	}

	new BB_NJBA_Addon();

}
else
{
	// Display admin notice for activating beaver builder
	add_action( 'admin_notices', 'njba_admin_notices' );
	add_action( 'network_admin_notices', 'njba_admin_notices' );

	function njba_admin_notices() {

		$url = admin_url( 'plugins.php' );

		echo '<div class="notice notice-error"><p>';
		echo sprintf( __( "You currently have two versions of <strong> Ninja Beaver Addon for Beaver Builder</strong> active on this site. Please <a href='%s'>deactivate one</a> before continuing.", 'bb-njba' ), $url );
	    echo '</p></div>';

  	}
}