<?php
class NJBAMySettingsPage
{
    /**
     * Holds the values to be used in the fields callbacks
     */
    private $options;

    /**
     * Start up
     */
    public function __construct()
    {
        add_action( 'admin_menu', array( $this, 'njba_add_plugin_page' ) );
        add_action( 'admin_init', array( $this, 'njba_page_init' ) );
    }

    /**
     * Add options page
     */
    public function njba_add_plugin_page()
    {
        // This page will be under "Settings"
        add_options_page( 'Settings Admin', 'NJBA', 'manage_options', 'njba-admin-setting', array( $this, 'njba_admin_options' ));
    }

    /**
     * Options page callback
     */
    public function njba_admin_options()
    {
        // Set class property
        $this->options = get_option( 'njba_options' );
        ?>
        <div class="wrap">
            <h1>NJBA Settings</h1>
            <form method="post" action="options.php">
            <?php
                // This prints out all hidden setting fields
                settings_fields( 'njba_option_group' );
                do_settings_sections( 'njba-admin-setting' );
                submit_button();
            ?>
            </form>
        </div>
        <?php
    }

    /**
     * Register and add settings
     */
    public function njba_page_init()
    {        
        register_setting(
            'njba_option_group', // Option group
            'njba_options', // Option name
            array( $this, 'njba_sanitize' ) // Sanitize
        );

        add_settings_section(
            'setting_section_id', // ID
            'My Custom Settings', // Title
            array( $this, 'njba_print_section_info' ), // Callback
            'njba-admin-setting' // Page
        );

        add_settings_field(
            'google_static_map_api_key', 
            'Google Static Map API Key', 
            array( $this, 'njba_google_static_map_api_key_callback' ), 
            'njba-admin-setting', 
            'setting_section_id'
        );

    }

    /**
     * Sanitize each setting field as needed
     *
     * @param array $input Contains all settings fields as array keys
     */
    public function njba_sanitize( $input )
    {
        $new_input = array();        

        if( isset( $input['google_static_map_api_key'] ) )
            $new_input['google_static_map_api_key'] = sanitize_text_field( $input['google_static_map_api_key'] );


        return $new_input;
    }

    /** 
     * Print the Section text
     */
    public function njba_print_section_info()
    {
        print 'Enter your settings below:';
    }

    /** 
     * Get the settings option array and print one of its values
     */
    public function njba_google_static_map_api_key_callback()
    {
        printf(
            '<input type="text" id="google_static_map_api_key" name="njba_options[google_static_map_api_key]" value="%s" />',
            isset( $this->options['google_static_map_api_key'] ) ? esc_attr( $this->options['google_static_map_api_key']) : ''
        );
        echo '<p><em>Click "Get a Key" from <a href="https://developers.google.com/maps/documentation/static-maps/" target="_blank">this page</a>. See <a href="https://wpdevelopers.co.uk/knowledge-base/generating-google-maps-javascript-api-key-gif/?utm_source=wpd-bb-modules-admin-settings&amp;utm_campaign=google-api-key&amp;utm_medium=wpd-bb-modules" target="_blank">this</a> article for instructions.</em></p>';
    }

   
}

if( is_admin() )
    $my_settings_page = new NJBAMySettingsPage();