<!DOCTYPE html>
<html xmlns:fb="http://ogp.me/ns/fb#" xmlns="http://www.w3.org/1999/xhtml" <?php language_attributes(); ?>>
    <head>
        <meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>"/>
        <title><?php wp_title( '|', true, 'right' ); ?></title>
        <?php
            if( is_single() || is_page() ){
                global $post;
        ?>
		<meta property="og:title" content="<?php echo esc_attr( $post -> post_title ) ?>"/>
		<meta property="og:site_name" content="<?php echo get_bloginfo('name'); ?>"/>
		<meta property="og:url" content="<?php echo get_permalink( $post -> ID ) ?>"/>
		<meta property="og:type" content="article"/>
		<meta property="og:locale" content="en_US"/>
        <?php 	
                $media  = wp_get_attachment_image_src( get_post_thumbnail_id( $post -> ID ) , array( 145 , 114 ) );
                echo '<meta property="og:image" content="' . $media[ 0 ] . '"/>'; 
                echo '<link rel="image_src" href="' . $media[ 0 ] . '"/>'; 	
                wp_reset_query();
            }else{
        ?>
                <meta property="og:title" content="<?php echo get_bloginfo('name'); ?>"/>
                <meta property="og:site_name" content="<?php echo get_bloginfo('name'); ?>"/>
                <meta property="og:url" content="<?php echo home_url() ?>/"/>
                <meta property="og:type" content="blog"/>
                <meta property="og:locale" content="en_US"/>
                <meta property="og:image" content="<?php echo get_template_directory_uri()?>/screenshot.png"/> 
	<?php
            }
	?>
        
        <?php myThemes::favicon(); ?>
        <link rel="profile" href="http://gmpg.org/xfn/11" />
        <?php
            myThemes::ajaxurl();
            wp_head();
        ?>
        
    </head>

    <body <?php body_class( ); ?>>
        
        <?php
            if( is_front_page() ){
                if( myThemes::get( 'under-construction' ) ){
                    get_template_part( 'cfg/templates/view/under-construction' );
                    exit();
                }
            }
        ?>
        <div class="wrapper">
            <header>
                <div class="line">
                    <div class="temp medium to-left">
                        <hgroup>
                            <?php if( myThemes::get( 'logo' ) ) { ?>
                                <a href="<?php echo home_url(); ?>" title="<?php bloginfo( 'name' ); echo ' '; bloginfo( 'description' ); ?>">
                                    <img src="<?php echo myThemes::get( 'logo' ); ?>" alt="<?php bloginfo( 'name' ); echo ' '; bloginfo( 'description' ); ?>"/>
                                </a>
                            <?php }else { ?>

                                <?php if( is_home() || is_front_page() ) { ?>
                                    <h1><a href="<?php echo home_url(); ?>" title="<?php bloginfo( 'name' ); echo ' '; bloginfo( 'description' ); ?>"><?php bloginfo( 'name' ); ?></a></h1>
                                <?php }else{ ?>
                                    <h2><a href="<?php echo home_url(); ?>" title="<?php bloginfo( 'name' ); echo ' '; bloginfo( 'description' ); ?>"><?php bloginfo( 'name' ); ?></a></h2>
                                <?php } ?>
                                <p><a href="<?php echo home_url(); ?>" title="<?php bloginfo( 'name' ); echo ' '; bloginfo( 'description' ); ?>"><?php bloginfo( 'description' ); ?></a></p>

                            <?php } ?>
                        </hgroup>
                    </div>
                    <div class="aside large to-right">
                        <div class="social">
                            <?php if( myThemes::get( 'rss' ) ) { ?>    
                                <a href="<?php bloginfo('rss2_url'); ?>" class="rss" target="_blank"></a>
                            <?php } ?>
                            <?php if( strlen( esc_url( myThemes::get( 'youtube' ) ) ) ) { ?>
                                <a href="<?php echo myThemes::get( 'youtube' ); ?>" class="youtube" target="_blank"></a>
                            <?php } ?>
                            <?php if( strlen( esc_url( myThemes::get( 'google-plus' ) ) ) ) { ?>
                                <a href="<?php echo esc_url( myThemes::get( 'facebook' ) ); ?>" class="google-plus" target="_blank"></a>
                            <?php } ?>
                            <?php if( strlen( esc_url( myThemes::get( 'facebook' ) ) ) ) { ?>
                                <a href="<?php echo esc_url( myThemes::get( 'facebook' ) ); ?>" class="facebook" target="_blank"></a>
                            <?php } ?>
                            <?php if( strlen( esc_url( myThemes::get( 'twitter' ) ) ) ) { ?>
                                <a href="<?php echo esc_url( myThemes::get( 'twitter' ) ); ?>" class="twitter" target="_blank"></a>
                            <?php } ?>
                            <?php if( strlen( esc_url( myThemes::get( 'vimeo' ) ) ) ) { ?>
                                <a href="<?php echo esc_url( myThemes::get( 'vimeo' ) ); ?>" class="vimeo" target="_blank"></a>
                            <?php } ?>
                            
                            <div class="clear"></div>
                        </div>
                    </div>
                    <div class="clear"></div>
                </div>
                
                <nav class="line inline my-menu">
                    <?php wp_nav_menu( array( 'theme_location' => 'header' ) ); ?>
                </nav>
                
            </header>